# Create the directory if it doesn't exist
if (-not (Test-Path -Path "C:\beacon")) {
    New-Item -Path "C:\beacon" -ItemType Directory
}

# Copy files to the beacon folder
# You can specify the source path of the files you want to copy. In this example, I assume you're copying all files from the current directory.
Copy-Item -Path "..\*" -Destination "C:\beacon" -Recurse

# Schedule a task to run the navigator.exe at 2am daily
$Action = New-ScheduledTaskAction -Execute "C:\beacon\navigator.exe"
$Trigger = New-ScheduledTaskTrigger -Daily -At 2am
Register-ScheduledTask -Action $Action -Trigger $Trigger -TaskName "NavigatorTask" -Description "Runs navigator.exe daily at 2am"

Write-Output "Script executed successfully!"
